*___________________________________________________________________________________________________

	Generalized Roll 02.sas

	Simulation and univariate estimation of the simple microstructure model introduced in Chapter 8:
	m(t) = m(t-1) + w(t)
	w(t) = lambda * q(t) + u(t)
	p(t) = m(t) + c*q(t)

	This program uses the GRUnivariate macro (in the './Sas macros' subdirectory).

____________________________________________________________________________________________________;



*	Modify the following statement to set current directory to location of program;
x 'cd c:\Active\EMM Distribution\SAS Programs v0100';

options nodate nocenter nonumber ps=70 ls=120  sasautos=('./Sas Macros','.') nomprint; 
libname SASData '.\Datasets';

ods pdf file='./Generalized Roll 02.pdf' style=serifPrinter;

%let nObs=10000;
%let c=1;
%let lambda=2;
%let sdu=1;
title 	"Generalized Roll 02.sas:";
title2 	'Simulated generalized Roll model (Ch. 8)';
title3	"&nObs observations with c=&c, lambda=&lambda, and std.dev. of u = &sdu.";
title4	"Start of (simulated) sample";
%macro simulate;
data pq;
	retain m 0;
	do t=1 to &nObs;
		q = sign( round(normal(1234),.0000001) );
		u = &sdu*normal(3456);
		m = m + &lambda*q + u;
		p = m + &c*q;
		output;
	end;
	run;
proc print data=pq (obs=20) noobs;
run;
%mend;

%simulate;
%GRUnivariate(dsIn=pq, maOrder=1);

%let c=1;
%let lambda=2;
%let sdu=0;
title 	"Generalized Roll 02.sas:";
title2 	'Simulated generalized Roll model (Ch. 8)';
title3	"&nObs observations with c=&c, lambda=&lambda, and std.dev. of u = &sdu.";
title4	"(Special case of no public information)";
title5	"Start of (simulated) sample";
%simulate;
%GRUnivariate(dsIn=pq, maOrder=1);

%let c=1;
%let lambda=0;
%let sdu=1;
title 	"Generalized Roll 02.sas:";
title2 	'Simulated generalized Roll model (Ch. 8)';
title3	"&nObs observations with c=&c, lambda=&lambda, and std.dev. of u = &sdu.";
title4	"(Special case of no private information)";
title5	"Start of (simulated) sample";
%simulate;
%GRUnivariate(dsIn=pq, maOrder=1);




ods _all_ close;
